/*
 * Decompiled with CFR 0.152.
 */
package com.dao.process;

import com.dao.process.ProcessDao;
import com.dto.InvoiceDto;
import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.concurrent.atomic.AtomicReference;

public class OrderProcessDao
extends ProcessDao<InvoiceDto.InvoiceInfo> {
    double oldPriceOrder;

    public OrderProcessDao(DbConnection dbConnection, LoginDto login, String blob, double oldPriceOrder) {
        super(dbConnection, login, blob);
        this.oldPriceOrder = oldPriceOrder;
    }

    protected String generateComment(InvoiceDto.InvoiceInfo data, ProcessDao.ProcessKind processKind) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        AtomicReference<Double> sumPrice = new AtomicReference<Double>(0.0);
        data.getDetailinfo().forEach(e -> {
            Double cfr_ignored_0 = (Double)sumPrice.updateAndGet(v -> new Double(v + e.getPrice()));
        });
        if (processKind.equals((Object)ProcessDao.ProcessKind.ADD)) {
            result = sb.append("\u062b\u0628\u062a \u0633\u0641\u0627\u0631\u0634\u0627\u062a ").append(data.getInvoiceType().getFarsiName()).append(data.getCustomername()).append(" \u0634\u0645\u0627\u0631\u0647 \u0633\u0641\u0627\u0631\u0634 : ").append(data.getCode()).append(" \u0648 \u0645\u0628\u0644\u063a").append(sumPrice).toString();
            if (data.getCash() + data.getBank() > sumPrice.get()) {
                throw new TncException(TncExceptionMessages.INVALID_BEIANEH_IN_INSERT_OR_EDIT_ORDER);
            }
        } else if (processKind.equals((Object)ProcessDao.ProcessKind.EDIT)) {
            result = sb.append("\u0627\u0635\u0644\u0627\u062d \u0633\u0641\u0627\u0631\u0634\u0627\u062a ").append(data.getInvoiceType().getFarsiName()).append(" ").append(data.getCustomername()).append(" \u0634\u0645\u0627\u0631\u0647 \u0633\u0641\u0627\u0631\u0634 : ").append(data.getCode()).append(" \u0627\u0632 \u0645\u0628\u0644\u063a").append(this.oldPriceOrder).append(" \u0628\u0647 \u0645\u0628\u0644\u063a ").append(sumPrice).append(" \u0627\u0635\u0644\u0627\u062d \u06af\u0631\u062f\u06cc\u062f ").toString();
            if (data.getCash() + data.getBank() > sumPrice.get()) {
                throw new TncException(TncExceptionMessages.INVALID_BEIANEH_IN_INSERT_OR_EDIT_ORDER);
            }
        }
        if (result.length() > 485) {
            result = result.substring(0, 485);
        }
        return result;
    }

    protected String getNumber(InvoiceDto.InvoiceInfo data) {
        return data.getRegisterType() == 1 ? data.getId() : String.valueOf(data.getSanadcode());
    }

    protected String getNameProc(InvoiceDto.InvoiceInfo data) {
        return "O";
    }

    protected String getCCode(InvoiceDto.InvoiceInfo data) {
        return data.getCustomerid();
    }
}

